--[[
Module d'interface entre le jeu et le loader C# pour FSVR
Ce module charge la bibliothèque C# et expose les fonctions nécessaires pour l'intégration avec le jeu
]]

FSVRLoaderBridge = {}

-- État du loader
FSVRLoaderBridge.isLoaded = false
FSVRLoaderBridge.isInitialized = false

-- Chemin vers la bibliothèque C#
FSVRLoaderBridge.loaderPath = g_currentModDirectory .. "libs/FSVRLoader.dll"

-- Fonctions C# exposées
FSVRLoaderBridge.initialize = nil
FSVRLoaderBridge.update = nil
FSVRLoaderBridge.shutdown = nil

---Charge la bibliothèque C#
function FSVRLoaderBridge:load()
    if self.isLoaded then
        return true
    end
    
    print("[FSVR] Chargement de la bibliothèque C#: " .. self.loaderPath)
    
    -- Vérification de l'existence du fichier
    local fileExists = fileExists(self.loaderPath)
    if not fileExists then
        print("[FSVR] [ERROR] La bibliothèque C# n'existe pas: " .. self.loaderPath)
        return false
    end
    
    -- Chargement de la bibliothèque C#
    -- Note: Dans une implémentation réelle, cela utiliserait une fonction spécifique pour charger une bibliothèque .NET
    -- Pour ce prototype, nous simulons le chargement
    
    -- Simulation de l'exposition des fonctions C#
    self.initialize = function(modDirectory)
        print("[FSVR] Appel de la fonction C# Initialize")
        -- Simulation d'un succès
        return true
    end
    
    self.update = function(deltaTime)
        -- Pas de log pour éviter de spammer la console
    end
    
    self.shutdown = function()
        print("[FSVR] Appel de la fonction C# Shutdown")
    end
    
    self.isLoaded = true
    print("[FSVR] Bibliothèque C# chargée avec succès")
    return true
end

---Initialise le loader
function FSVRLoaderBridge:initialize()
    if self.isInitialized then
        return true
    end
    
    if not self.isLoaded then
        if not self:load() then
            return false
        end
    end
    
    print("[FSVR] Initialisation du loader C#")
    
    -- Appel de la fonction C# Initialize
    local success = self.initialize(g_currentModDirectory)
    if not success then
        print("[FSVR] [ERROR] Échec de l'initialisation du loader C#")
        return false
    end
    
    self.isInitialized = true
    print("[FSVR] Loader C# initialisé avec succès")
    return true
end

---Met à jour le loader
function FSVRLoaderBridge:update(dt)
    if not self.isInitialized then
        return
    end
    
    -- Appel de la fonction C# Update
    self.update(dt)
end

---Décharge le loader
function FSVRLoaderBridge:shutdown()
    if not self.isInitialized then
        return
    end
    
    print("[FSVR] Fermeture du loader C#")
    
    -- Appel de la fonction C# Shutdown
    self.shutdown()
    
    self.isInitialized = false
    print("[FSVR] Loader C# fermé avec succès")
end

---Vérifie si le loader est initialisé
function FSVRLoaderBridge:isInitialized()
    return self.isInitialized
end

-- Initialisation automatique lors du chargement du module
FSVRLoaderBridge:load()

return FSVRLoaderBridge
