# Bibliothèques externes requises

Ce document liste les bibliothèques externes qui doivent être ajoutées à ce dossier pour que le mod VR fonctionne correctement avec le loader C#.

## Bibliothèques .NET

### NLua

NLua est une bibliothèque qui permet d'intégrer Lua dans .NET. Elle est utilisée par le loader C# pour exécuter les scripts Lua du mod.

- **Fichier requis**: `NLua.dll`
- **Version recommandée**: 1.6.0 ou supérieure
- **Site officiel**: [https://github.com/NLua/NLua](https://github.com/NLua/NLua)
- **Installation**: Téléchargez la dernière version depuis le site officiel ou utilisez NuGet pour l'installer, puis copiez le fichier DLL dans ce dossier.

### OpenXR.Net

OpenXR.Net est un wrapper .NET pour l'API OpenXR. Elle est utilisée par le loader C# pour interagir avec les casques VR.

- **Fichier requis**: `OpenXR.Net.dll`
- **Version recommandée**: La dernière version compatible avec .NET 6.0
- **Installation**: Vous pouvez créer cette bibliothèque vous-même en utilisant P/Invoke pour appeler les fonctions de la bibliothèque OpenXR native, ou utiliser une bibliothèque existante comme [OpenXR-CS](https://github.com/Zumict/OpenXR-CS) ou [OpenXR-SDK-CSharp](https://github.com/Perfare/OpenXR-SDK-CSharp).

## Bibliothèques natives OpenXR

### OpenXR Loader

Le loader OpenXR est la bibliothèque native qui permet d'interagir avec les runtimes OpenXR installés sur le système.

#### Windows

- **Fichier requis**: `openxr_loader.dll`
- **Version recommandée**: 1.0.26 ou supérieure
- **Site officiel**: [https://www.khronos.org/openxr/](https://www.khronos.org/openxr/)
- **Installation**: Téléchargez la dernière version depuis le site officiel ou utilisez un runtime OpenXR comme SteamVR, Oculus, ou Windows Mixed Reality, qui installent généralement cette bibliothèque.

#### Linux

- **Fichier requis**: `libopenxr_loader.so`
- **Version recommandée**: 1.0.26 ou supérieure
- **Installation**: Installez le package `libopenxr-loader` via le gestionnaire de paquets de votre distribution, puis copiez le fichier dans ce dossier.

#### macOS

- **Fichier requis**: `libopenxr_loader.dylib`
- **Version recommandée**: 1.0.26 ou supérieure
- **Installation**: Compilez la bibliothèque à partir des sources ou utilisez un runtime OpenXR compatible avec macOS.

## Note importante

Si vous ne disposez pas de ces bibliothèques, le mod fonctionnera en mode simulation, sans accès réel aux casques VR. Le mode simulation est utile pour le développement et les tests, mais ne permet pas d'utiliser le mod en VR.

Pour une expérience VR complète, assurez-vous d'avoir toutes les bibliothèques requises et un casque VR compatible avec OpenXR.
