# Farming Simulator 25 VR Mod

Ce mod permet de jouer à Farming Simulator 25 en réalité virtuelle (VR) en utilisant la technologie OpenXR, compatible avec la plupart des casques VR du marché.

## Compatibilité

Ce mod est compatible avec :
- Oculus/Meta Quest 2/3/Pro (via Link ou Air Link)
- Valve Index
- HTC Vive/Vive Pro/Vive Cosmos
- Windows Mixed Reality
- Pico Neo
- Autres casques compatibles OpenXR

## Prérequis

- Farming Simulator 25
- Un casque VR compatible OpenXR
- Un runtime OpenXR installé (SteamVR, Oculus, Windows Mixed Reality, etc.)
- Configuration minimale recommandée :
  - CPU : Intel Core i5-8600K ou AMD Ryzen 5 3600
  - GPU : NVIDIA GTX 1070 ou AMD RX 5700
  - RAM : 16 Go
  - Stockage : 2 Go d'espace libre

## Installation

1. Téléchargez la dernière version du mod depuis la page des releases.
2. Extrayez le contenu de l'archive dans le dossier des mods de Farming Simulator 25 :
   - Windows : `Documents\My Games\FarmingSimulator2025\mods\`
   - macOS : `~/Library/Application Support/FarmingSimulator2025/mods/`
3. Assurez-vous que votre runtime OpenXR est correctement configuré et que votre casque VR est connecté.
4. Lancez Farming Simulator 25 et activez le mod dans le menu des mods.

## Utilisation

### Contrôles

Le mod utilise les contrôleurs VR pour interagir avec le jeu :

#### Contrôleur gauche
- Gâchette : Frein
- Grip : Embrayage
- Bouton A/X : Activer/désactiver les phares
- Bouton B/Y : Activer/désactiver les gyrophares
- Bouton Menu : Ouvrir/fermer le menu du jeu
- Joystick : Déplacement du véhicule (gauche/droite, avant/arrière)
- Appui sur joystick : Réinitialiser la position

#### Contrôleur droit
- Gâchette : Accélérateur
- Grip : Attacher/détacher l'outil
- Bouton A/X : Fonction supplémentaire de l'outil
- Bouton B/Y : Fonction supplémentaire 2 de l'outil
- Bouton Menu : Activer/désactiver le régulateur de vitesse
- Joystick : Regarder autour de soi
- Appui sur joystick : Changer de caméra

### Conduite des véhicules

En VR, vous pouvez conduire les véhicules de deux façons :
1. En utilisant les contrôleurs comme un volant virtuel (tenir les deux contrôleurs comme si vous teniez un volant)
2. En utilisant le joystick gauche pour diriger le véhicule

### Interface utilisateur

L'interface utilisateur a été adaptée pour la VR :
- Les menus apparaissent devant vous dans l'espace 3D
- Un pointeur laser émane du contrôleur droit pour interagir avec les menus
- Le HUD est attaché à votre regard pour une meilleure lisibilité

## Configuration

Vous pouvez configurer le mod en modifiant le fichier `config.xml` dans le dossier du mod. Les options disponibles incluent :

- Résolution de rendu
- Niveau de MSAA
- Activation du rendu fovéal
- Échelle et distance du HUD
- Mapping des boutons des contrôleurs
- Et bien plus...

## Dépannage

### Le casque VR n'est pas détecté
- Assurez-vous que votre runtime OpenXR est correctement installé et configuré
- Vérifiez que votre casque est connecté et fonctionne avec d'autres applications VR
- Redémarrez le jeu et le runtime VR

### Performances faibles
- Réduisez la résolution de rendu dans le fichier de configuration
- Activez le rendu fovéal si votre casque le supporte
- Réduisez les paramètres graphiques du jeu
- Assurez-vous que votre ordinateur répond aux exigences minimales

### Problèmes de contrôle
- Vérifiez que vos contrôleurs sont correctement chargés et connectés
- Recalibrez vos contrôleurs dans les paramètres de votre plateforme VR
- Vérifiez le mapping des boutons dans le fichier de configuration

## Crédits

- Développé par l'équipe 0xVertake
- Utilise la technologie OpenXR
- Farming Simulator est une marque déposée de GIANTS Software

## Licence

Ce mod est distribué sous licence libre et peut être modifié et redistribué librement, à condition de mentionner les auteurs originaux.

---

Pour toute question ou suggestion, veuillez ouvrir une issue sur le dépôt GitHub du projet.
